package com.ejie.ab04b.service.nora;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.nora.MunicipioDao;
import com.ejie.ab04b.model.nora.Municipio;

/**
 * MunicipioServiceImpl.
 * 
 * @author GFI
 */
@Service(value = "municipioService")
public class MunicipioServiceImpl implements MunicipioService {

	@Autowired()
	private MunicipioDao municipioDao;

	/**
	 * Finds a single row in the Municipio table.
	 * 
	 *  municipio
	 *            Municipio
	 *  Municipio
	 *
	 * @param municipio the municipio
	 * @return the municipio
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public Municipio find(Municipio municipio) {
		return (Municipio) this.municipioDao.find(municipio);
	}

	/**
	 * Finds a List of rows in the Municipio table.
	 * 
	 *  municipio
	 *            Municipio
	 *  List
	 *
	 * @param municipio the municipio
	 * @return the list
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public List<Municipio> findAll(Municipio municipio) {
		return (List<Municipio>) this.municipioDao.findAll(municipio);
	}

	/**
	 * Counts rows in the Municipio table.
	 * 
	 *  municipio
	 *            Municipio
	 *  Long
	 *
	 * @param municipio the municipio
	 * @return the long
	 */
	@Transactional(propagation = Propagation.SUPPORTS, isolation = Isolation.READ_COMMITTED)
	public Long findAllCount(Municipio municipio) {
		return this.municipioDao.findAllCount(municipio);
	}

	/* (non-Javadoc)
	 * @see com.ejie.ab04b.service.nora.MunicipioService#findAllFirst(com.ejie.ab04b.model.nora.Municipio)
	 */
	public Municipio findAllFirst(Municipio municipio) {
		return this.municipioDao.findAllFirst(municipio);
	}
}